%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Exercise 10.12  
% File: MSFE.m
% 
% Purpose: Using MC simulation, the computer code computes
% the MSFEs of three predictors for forecasts obtained 
% from a superdiagonal BL model, with
%   NLP = Nonlinear predictor;
%   QP  = Quadratic predictor; and
%   LP  = Linear (least squares) predictor.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
nrep = 2000;
N    = 100;

for b = 1:131
   beta     = -0.65+(b-1)*0.01;
   index(b) = beta;
   for it = 1:nrep
      e    = normrnd(0,1,154,1);
      y(1) = 0;
      y(2) = 0;

%     Simulate time series 
      for i = 3:154
         y(i) = beta*y(i-2)*e(i-1)+e(i);  % BL process
      end
      w = y(103:154); % 52 data points, 100 observations for warming up     
      w0     = 0; 
      res(1) = w(1);
      res(2) = w(2)-beta*w0*res(1);
      res(3) = w(3)-beta*w(1)*res(2);
      for u = 4:52
          res(u) = w(u)-beta*w(u-2)*res(u-1);
      end

       wLtrue1(it) = w(51);  % actual values
       wLtrue2(it) = w(52);
        
       NLP1(it)   = beta*w(49)*res(50); % 1-step ahead NL
       QP1(it)    = beta*w(49)*w(50);   % 1-step ahead QP
       resNLP(51) = w(51)-NLP1(it);
             
       sum1 = 0;
       sum2 = 0;   
       sum3 = 0;
       for u = 1:N
          ee   = datasample(e,1);
          sum1 = sum1 + beta*w(50)*resNLP(51)+ee; % 2-step ahead NL: 
                                  % 52 conditional on res(51) and w(50)
          sum2 = sum2 + beta*w(50)*QP1(it)+ee;    % 2-step ahead QP: 
                                  % 52 conditional on QP(51) and w(50)
          sum3 = sum3 + ee;
       end
       NLP2(it) = sum1/N;
       QP2(it)  = sum2/N;
       LP2(it)  = sum3/N;      
    end  % it=1:nrep
 
    mseNLP1 = 0;
    mseNLP2 = 0;    
    mseQP1  = 0;    
    mseQP2  = 0;    
    mseLP1  = 0;
    mseLP2  = 0;

    for it=1:nrep
        mseNLP1 = mseNLP1+(wLtrue1(it)-NLP1(it))^2;
        mseNLP2 = mseNLP2+(wLtrue2(it)-NLP2(it))^2;
             
        mseQP1  = mseQP1+(wLtrue1(it)-QP1(it))^2;
        mseQP2  = mseQP2+(wLtrue2(it)-QP2(it))^2;
        
        mseLP1 = mseLP1+wLtrue1(it)^2;  % 1-step ahead LS forecasts are zero
        mseLP2 = mseLP2+(wLtrue2(it)-LP2(it))^2;        
    end

    RMSE1(b) = mseNLP1/mseQP1;  % Nonlinear vs. QP
    RMSE2(b) = mseNLP2/mseQP2;
    
    RMSLP1(b) = mseLP1/mseQP1;  % Linear vs. QP
    RMSLP2(b) = mseLP2/mseQP2;    
    
end %   end beta loop 

% Relative Mean Square Errors
RMSE_NLP_QP1 = [RMSE1;index]'; 
RMSE_NLP_QP2 = [RMSE2;index]'; 

RMSE_LP_QP1  = [RMSLP1;index]'; 
RMSE_LP_QP2  = [RMSLP2;index]'; 